;======================================================================
;======================================================================
; Damage states file for "Kanna"
;======================================================================
;======================================================================

;----------------------------------------------------------------------
; Wire Damage
;
;45000		- Initialize velocity and change animation
;45001		- Scatter to wall
;45002		- Crash into wall
;45003		- Turn to opposite
;45004		- Fall in down

[Statedef 45000]
type = A
movetype = H
physics = N

[State 45000, ChangeAnim2]
type = ChangeAnim2
trigger1 = 1
value = 45000

[State 45000, VarSet]	;Use sysvar(1)
type = VarSet
trigger1 = Time = 0
sysvar(1) = GetHitVar(fall.recovertime)

[State 45000, VarAdd]	;Use sysvar(1)
type = VarAdd
trigger1 = Time > 0
trigger1 = sysvar(1) > 0
sysvar(1) = -1

[State 45000, PlayerPush]
type = PlayerPush
trigger1 = 1
value = 0

[State 45000, VelSet]
type = VelSet
trigger1 = 1
x = 0
y = 0

[State 45000, ChangeState]
type = ChangeState
trigger1 = HitShakeOver = 1
value = 45001

[State 45000, Kill Helper]
type = DestroySelf
trigger1 = IsHelper

[Statedef 45001]
type = A
movetype = H
physics = N

[State 45001, VelAdd]
type = VelAdd
trigger1 = 1
y = 0.35

[State 45001, VarAdd]	;Use sysvar(1)
type = VarAdd
trigger1 = sysvar(1) > 0
sysvar(1) = -1

[State 45001, PlayerPush]
type = PlayerPush
trigger1 = 1
value = 0

[State 45001, VelSet]
type = HitVelSet
trigger1 = Time = 0
x = 1
y = 1

[State 45001, ChangeState]
type = ChangeState
trigger1 = BackEdgeBodyDist < 5
value = 45002

[State 45001, SelfState]
type = SelfState
trigger1 = Time > 3
trigger1 = (Vel Y > 0) && (Pos Y >= 0)
value = 5100

[Statedef 45002]
type = A
movetype = H
phisics = N

[State 45002, VarSet]	;Use sysvar(1)
type = VarSet
trigger1 = Time = 0
sysvar(1) = sysvar(1)*2

[State 45002, VarAdd]	;Use sysvar(1)
type = VarAdd
trigger1 = sysvar(1) > 0
sysvar(1) = -1

[State 45002, ChangeAnim2]
type = ChangeAnim2
trigger1 = Time = 0
value = 45002

[State 40672, EnvShake]
type = EnvShake
trigger1 = Time = 0
time = 5
ampl = -7

[State 45002, ChangeState]
type = ChangeState
trigger1 = Time = 1
value = 45003

[Statedef 45003]
type = A
movetype = H
phisics = N
velset = 0,0

[State 45003, VarSet]	;Use sysvar(1)
type = VarAdd
trigger1 = sysvar(1) > 0
sysvar(1) = -1

[State 45003, SelfState]
type = SelfState
trigger1 = CanRecover
trigger1 = sysvar(1) = 0
trigger1 = command = "recovery"
value = 5210

[State 45003, AngleDraw]
type = AngleDraw
trigger1 = 1

[State 45003, AngleSet]
type = AngleSet
trigger1 = 1
value = Time*30

[State 45003, VelSet]
type = VelSet
trigger1 = Time = 0
x = 1.5
y = -8

[State 45003, VelAdd]
type = VelAdd
trigger1 = 1
y = 0.25

[State 45003, VarSet]	;Use sysvar(1)
type = VarSet
trigger1 = (Vel Y > 0) && (Pos Y >= 0)
sysvar(1) = 0

[State 45003, SelfState]
type = SelfState
trigger1 = (Vel Y > 0) && (Pos Y >= 0)
value = 5100

;----------------------------------------------------------------------
; Fire Damage - Fall/P1

[Statedef 45010]
type = A
movetype = H
physics = N
velset = 0,0

[State 45010, VarSet]	;Use sysvar(1)
type = VarSet
trigger1 = Time = 0
sysvar(1) = GetHitVar(fall.recovertime)

[State 45010, VarAdd]	;Use sysvar(1)
type = VarAdd
trigger1 = sysvar(1) > 0
sysvar(1) = -1

[State 45010, ChangeAnim2]
type = ChangeAnim2
trigger1 = 1
value = 45010

[State 45010, ChangeState]
type = ChangeState
trigger1 = HitShakeOver
value = 45011

;----------------------------------------------------------------------
; Fire Damage - Fall/P1

[Statedef 45011]
type = A
movetype = H
physics = N
velset = GetHitVar(xvel)*Facing,GetHitVar(yvel)

[State 45011, SelfState]
type = SelfState
trigger1 = CanRecover
trigger1 = sysvar(1) = 0
trigger1 = command = "recovery"
value = 5210

[State 45011, NotHitBy]
type = NotHitBy
trigger1 = sysvar(1) = 0
time = 1
value = SCA

[State 45011, VarAdd]	;Use sysvar(1)
type = VarAdd
trigger1 = sysvar(1) > 0
sysvar(1) = -1

[State 45011, VelSet]
type = VelSet
trigger1 = Time = 10
x = 0

[State 45011, VelAdd]
type = VelAdd
trigger1 = Time > 5
y = 0.35

[State 45011, PalFX]
type = PalFX
trigger1 = Time = 0
time = 40
add = 80,-44,-124
sinadd = 30,30,0,10
color = 0
invertall = 1
persistent = 0

[State 45011, ChangeAnim]
type = ChangeAnim
triggerall = Anim != 5055 && Anim != 5700 && Anim != 3595 && Anim != 9015
triggerall = Time = 5
trigger1 = SelfAnimExist(7697)
value = 7697
persistent = 0

[State 45011, ChangeAnim]
type = ChangeAnim
triggerall = SelfAnimExist(5055)
triggerall = Time = 4
trigger1 = Name = "Ayu Tukimiya" && AuthorName = "shikkoku"
value = 5055
persistent = 0

[State 45011, ChangeAnim]
type = ChangeAnim
triggerall = SelfAnimExist(5700)
triggerall = Time = 4
trigger1 = Name = "Nayuki Minase" && AuthorName = "EL"
value = 5700
persistent = 0

[State 45011, ChangeAnim]
type = ChangeAnim
triggerall = SelfAnimExist(3595)
trigger1 = Time = 4
trigger1 = Name = "Makoto Sawatari" && AuthorName = "EL"
value = 3595
persistent = 0

[State 45011, ChangeAnim]
type = ChangeAnim
triggerall = SelfAnimExist(9015)
triggerall = Time = 4
trigger1 = Name = "Mayu Shiina" && AuthorName = "BF"
trigger2 = Name = "Makoto Sawatari" && AuthorName = "BF"
value = 9015
persistent = 0

[State 45011, PalFX]
type = PalFX
trigger1 = Anim != 45010
time = 1
mul = 255,255,255
persistent = 0

[State 45011, SelfState]
type = SelfState
trigger1 = (Vel Y > 0) && (Pos Y >= 0)
value = 5100

;----------------------------------------------------------------------
; Fire Damage - Fall/P3

[Statedef 45020]
type = A
movetype = H
physics = N
velset = 0,0

[State 45020, VarSet]	;Use sysvar(1)
type = VarSet
trigger1 = Time = 0
sysvar(1) = GetHitVar(fall.recovertime)

[State 45020, VarAdd]	;Use sysvar(1)
type = VarAdd
trigger1 = sysvar(1) > 0
sysvar(1) = -1

[State 45020, ChangeAnim2]
type = ChangeAnim2
trigger1 = 1
value = 45020

[State 45010, ChangeState]
type = ChangeState
trigger1 = HitShakeOver
value = 45021

;----------------------------------------------------------------------
; Fire Damage - Fall/P3

[Statedef 45021]
type = A
movetype = H
physics = N
velset = GetHitVar(xvel)*Facing,GetHitVar(yvel)

[State 45021, NotHitBy]
type = NotHitBy
trigger1 = sysvar(1) = 0
time = 1
value = SCA

[State 45021, SelfState]
type = SelfState
trigger1 = CanRecover
trigger1 = sysvar(1) = 0
trigger1 = command = "recovery"
value = 5210

[State 45021, VarAdd]	;Use sysvar(1)
type = VarAdd
trigger1 = sysvar(1) > 0
sysvar(1) = -1

[State 45021, VelSet]
type = VelSet
trigger1 = Time = 10
x = 0

[State 45021, VelAdd]
type = VelAdd
trigger1 = Time > 5
y = 0.35

[State 45021, PalFX]
type = PalFX
trigger1 = Time = 0
time = 40
add = 80,-44,-124
sinadd = 30,30,0,10
color = 0
invertall = 1
persistent = 0

[State 45021, ChangeAnim]
type = ChangeAnim
triggerall = Anim != 5055 && Anim != 5700 && Anim != 3595 && Anim != 9015
triggerall = Time = 7
trigger1 = SelfAnimExist(7697)
value = 7697
persistent = 0

[State 45021, ChangeAnim]
type = ChangeAnim
triggerall = SelfAnimExist(5055)
triggerall = Time = 6
trigger1 = Name = "Ayu Tukimiya" && AuthorName = "shikkoku"
value = 5055
persistent = 0

[State 45021, ChangeAnim]
type = ChangeAnim
triggerall = SelfAnimExist(5700)
triggerall = Time = 6
trigger1 = Name = "Nayuki Minase" && AuthorName = "EL"
value = 5700
persistent = 0

[State 45021, ChangeAnim]
type = ChangeAnim
triggerall = SelfAnimExist(3595)
trigger1 = Time = 6
trigger1 = Name = "Makoto Sawatari" && AuthorName = "EL"
value = 3595
persistent = 0

[State 45021, ChangeAnim]
type = ChangeAnim
triggerall = SelfAnimExist(9015)
triggerall = Time = 6
trigger1 = Name = "Mayu Shiina" && AuthorName = "BF"
trigger2 = Name = "Makoto Sawatari" && AuthorName = "BF"
value = 9015
persistent = 0

[State 45021, PalFX]
type = PalFX
trigger1 = Anim != 45010
time = 1
mul = 255,255,255
persistent = 0

[State 45021, SelfState]
type = SelfState
trigger1 = (Vel Y > 0) && (Pos Y >= 0)
value = 5100

;----------------------------------------------------------------------
; Thunder Damage

[Statedef 45030]
type = A
movetype = H
physics = N
velset = -0.5,-1.2

[State 45030, ChangeAnim2]
type = ChangeAnim2
trigger1 = Time = 0
value = 45030

[State 45030, PalFX]
type = PalFX
trigger1 = Anim != 45030
time = 1
mul = 0,0,0
persistent = 0

[State 45030, ChangeAnim]
type = ChangeAnim
trigger1 = Anim = 45030
trigger1 = SelfAnimExist(7696)
value = 7696
persistent = 0

[State 45030, ChangeAnim]
type = ChangeAnim
triggerall = SelfAnimExist(9010)
trigger1 = Name = "Mayu Shiina" && AuthorName = "BF"
trigger2 = Name = "Makoto Sawatari" && AuthorName = "BF"
value = 9010
persistent = 0

[State 45030, ChangeAnim]
type = ChangeAnim
triggerall = SelfAnimExist(5056)
trigger1 = Name = "Ayu Tukimiya" && AuthorName = "shikkoku"
trigger2 = Name = "Mai Kawasumi" && AuthorName = "586"
value = 5056
persistent = 0

[State 45030, ChangeAnim]
type = ChangeAnim
triggerall = SelfAnimExist(5710)
trigger1 = Name = "Nayuki Minase" && AuthorName = "EL"
value = 5710
persistent = 0

[State 45030, ChangeAnim]
type = ChangeAnim
triggerall = SelfAnimExist(3590)
trigger1 = Name = "Makoto Sawatari" && AuthorName = "EL"
value = 3590
persistent = 0

[State 45030, ChangeState]
type = ChangeState
trigger1 = Time > 32
value = 45031

[State 45030, Kill Helper]
type = DestroySelf
trigger1 = IsHelper

[Statedef 45031]
type = A
movetype = H
physics = N

[State 45031, SelfState]
type = SelfState
trigger1 = Time = 2
value = 5000

[State 45031, Kill Helper]
type = DestroySelf
trigger1 = IsHelper

;----------------------------------------------------------------------
; Ice Damage - Fall/P1

[Statedef 45040]
type = A
movetype = H
physics = N

[State 45040, ChangeAnim2]
type = ChangeAnim2
trigger1 = Time = 0
value = 45040

[State 45040, VelSet]
type = HitVelSet
trigger1 = Time = 0
x = 1
y = 1

[State 45040, AssertSpecial]
type = AssertSpecial
trigger1 = 1
flag = invisible
ignorehitpause = 1

[State 45040, VelAdd]
type = VelAdd
trigger1 = Time > 1
y = 0.35

[State 45040, SelfState]
type = SelfState
trigger1 = (Vel Y > 0) && (Pos Y >= 0)
value = 5100

[State 45040, Kill Helper]
type = DestroySelf
trigger1 = IsHelper

;----------------------------------------------------------------------
; Ice Damage - Fall/P3

[Statedef 45045]
type = A
movetype = H
physics = N

[State 45045, ChangeAnim2]
type = ChangeAnim2
trigger1 = Time = 0
value = 45040

[State 45045, VelSet]
type = HitVelSet
trigger1 = Time = 0
x = 1
y = 1

[State 45045, AssertSpecial]
type = AssertSpecial
trigger1 = 1
flag = invisible
ignorehitpause = 1

[State 45045, VelAdd]
type = VelAdd
trigger1 = Time > 1
y = 0.35

[State 45045, SelfState]
type = SelfState
trigger1 = (Vel Y > 0) && (Pos Y >= 0)
value = 5100

[State 45045, Kill Helper]
type = DestroySelf
trigger1 = IsHelper

;----------------------------------------------------------------------
; Ice Damage - Ground/P1

[Statedef 45050]
type = A
movetype = H
physics = N

[State 45050, VarSet]	;Use sysvar(1)
type = VarSet
trigger1 = Time = 0
sysvar(1) = GetHitVar(fall.recovertime)

[State 45050, VarAdd]	;Use sysvar(1)
type = VarAdd
trigger1 = sysvar(1) > 0
sysvar(1) = -1

[State 45050, ChangeAnim2]
type = ChangeAnim2
trigger1 = Time = 0
value = 45050

[State 45050, VelSet]
type = HitVelSet
trigger1 = Time = 0
x = 1
y = 1

[State 45050, AssertSpecial]
type = AssertSpecial
trigger1 = 1
flag = invisible
ignorehitpause = 1

[State 45050, VelAdd]
type = VelAdd
trigger1 = Time > 1
y = 0.35

[State 45050, ChangeState]
type = ChangeState
trigger1 = Time > 1
trigger1 = (Vel Y > 0) && (Pos Y >= 0)
value = 45051

[State 45050, Kill Helper]
type = DestroySelf
trigger1 = IsHelper

;----------------------------------------------------------------------
; Ice Damage - Ground/P1

[Statedef 45051]
type = S
movetype = H
physics = S

[State 45051, VarAdd]	;Use sysvar(1)
type = VarAdd
trigger1 = sysvar(1) > 0
sysvar(1) = -1

[State 45051, NotHitBy]
type = NotHitBy
trigger1 = sysvar(1) = 0
time = 1
value = SCA

[State 45051, PosSet]
type = PosSet
trigger1 = Time = 0
y = 0

[State 45051, VelSet]
type = VelSet
trigger1 = Time = 0
y = 0

[State 45051, HitFallSet]
type = HitFallSet
trigger1 = Time = 0
value = 0

[State 45051, ChangeAnim2]
type = ChangeAnim2
trigger1 = Time = 0
value = 45050

[State 45051, AssertSpecial]
type = AssertSpecial
trigger1 = 1
flag = invisible
ignorehitpause = 1

[State 45051, ChangeState]
type = ChangeState
trigger1 = Time > 60
value = 45079

[State 45051, Kill Helper]
type = DestroySelf
trigger1 = IsHelper

;----------------------------------------------------------------------
; Ice Damage - Ground/P3

[Statedef 45055]
type = A
movetype = H
physics = N

[State 45055, VarSet]	;Use sysvar(1)
type = VarSet
trigger1 = Time = 0
sysvar(1) = GetHitVar(fall.recovertime)

[State 45055, VarAdd]	;Use sysvar(1)
type = VarAdd
trigger1 = sysvar(1) > 0
sysvar(1) = -1

[State 45055, ChangeAnim2]
type = ChangeAnim2
trigger1 = Time = 0
value = 45050

[State 45055, VelSet]
type = HitVelSet
trigger1 = Time = 0
x = 1
y = 1

[State 45055, AssertSpecial]
type = AssertSpecial
trigger1 = 1
flag = invisible
ignorehitpause = 1

[State 45055, VelAdd]
type = VelAdd
trigger1 = Time > 1
y = 0.35

[State 45055, ChangeState]
type = ChangeState
trigger1 = Time > 1
trigger1 = (Vel Y > 0) && (Pos Y >= 0)
value = 45056

[State 45055, Kill Helper]
type = DestroySelf
trigger1 = IsHelper

;----------------------------------------------------------------------
; Ice Damage - Ground/P3

[Statedef 45056]
type = S
movetype = H
physics = S

[State 45056, VarAdd]	;Use sysvar(1)
type = VarAdd
trigger1 = sysvar(1) > 0
sysvar(1) = -1

[State 45056, NotHitBy]
type = NotHitBy
trigger1 = sysvar(1) = 0
time = 1
value = SCA

[State 45056, PosSet]
type = PosSet
trigger1 = Time = 0
y = 0

[State 45056, VelSet]
type = VelSet
trigger1 = Time = 0
y = 0

[State 45056, HitFallSet]
type = HitFallSet
trigger1 = Time = 0
value = 0

[State 45056, ChangeAnim2]
type = ChangeAnim2
trigger1 = Time = 0
value = 45050

[State 45056, AssertSpecial]
type = AssertSpecial
trigger1 = 1
flag = invisible
ignorehitpause = 1

[State 45056, ChangeState]
type = ChangeState
trigger1 = Time > 60
value = 45079

[State 45056, Kill Helper]
type = DestroySelf
trigger1 = IsHelper

;----------------------------------------------------------------------
; Ice Damage - Fall/P1

[Statedef 45060]
type = A
movetype = H
physics = N

[State 45060, ChangeAnim2]
type = ChangeAnim2
trigger1 = Time = 0
value = 45040

[State 40560, ScreenBound]
type = ScreenBound
trigger1 = 1
value = 1
movecamera = 1,0

[State 45060, VelSet]
type = HitVelSet
trigger1 = Time = 0
x = 1
y = 1

[State 45060, AssertSpecial]
type = AssertSpecial
trigger1 = 1
flag = invisible
ignorehitpause = 1

[State 45060, VelAdd]
type = VelAdd
trigger1 = Time > 1
y = 0.35

[State 45060, SelfState]
type = SelfState
trigger1 = (Vel Y > 0) && (Pos Y >= 0)
value = 5100

[State 45060, Kill Helper]
type = DestroySelf
trigger1 = IsHelper

;----------------------------------------------------------------------
; Ice Damage - Fall/P3

[Statedef 45065]
type = A
movetype = H
physics = N

[State 40565, ScreenBound]
type = ScreenBound
trigger1 = 1
value = 1
movecamera = 1,0

[State 45065, ChangeAnim2]
type = ChangeAnim2
trigger1 = Time = 0
value = 45040

[State 45065, VelSet]
type = HitVelSet
trigger1 = Time = 0
x = 1
y = 1

[State 45065, AssertSpecial]
type = AssertSpecial
trigger1 = 1
flag = invisible
ignorehitpause = 1

[State 45065, VelAdd]
type = VelAdd
trigger1 = Time > 1
y = 0.35

[State 45065, SelfState]
type = SelfState
trigger1 = (Vel Y > 0) && (Pos Y >= 0)
value = 5100

[State 45065, Kill Helper]
type = DestroySelf
trigger1 = IsHelper

;----------------------------------------------------------------------
; Ice Damage - Ground/Recover

[Statedef 45079]
type = S
movetype = H
physics = S
velset = -5,0

[State 45079, ChangeAnim2]
type = ChangeAnim2
trigger1 = Time = 0
value = 45079

[State 45079, SelfState]
type = SelfState
trigger1 = AnimTime = 0
value = 0
ctrl = 1

[State 45079, Kill Helper]
type = DestroySelf
trigger1 = IsHelper

;----------------------------------------------------------------------
; 236236 + C
;
;47000		- HitShake
;47001		- Up to Air
;47002		- Invisible
;47003		- Fall
;47004		- Stop
;47005		- Up to Air

[Statedef 47000]
type = S
movetype = H
physics = N
velset = 0,0

[State 47000, ScreenBound]
type = ScreenBound
trigger1 = 1
value = 0
movecamera = 0,0

[State 47000, ChangeAnim2]
type = ChangeAnim2
trigger1 = Time = 0
value = 47000

[State 47001, SelfState]
type = SelfState
trigger1 = Time > 500
value = 5000

[Statedef 47001]
type = A
movetype = H
physics = N
velset = 0,0

[State 47001, ScreenBound]
type = ScreenBound
trigger1 = 1
value = 0
movecamera = 0,0

[State 47001, VelAdd]
type = VelSet
trigger1 = HitShakeOver
y = -20
persistent = 0

[State 47000, ChangeAnim2]
type = ChangeAnim2
trigger1 = HitShakeOver
value = 47000

[State 47001, ChangeState]
type = ChangeState
trigger1 = Time > 60
value = 47002

[Statedef 47002]
type = A
movetype = H
physics = N
velset = 0,0

[State 47002, AssertSpecial]
type = AssertSpecial
trigger1 = 1
flag = Invisible
ignorehitpause = 1

[State 47002, ScreenBound]
type = ScreenBound
trigger1 = 1
value = 0
movecamera = 0,0

[Statedef 47003]
type = A
movetype = H
physics = N
velset = 0,0

[State 47003, ScreenBound]
type = ScreenBound
trigger1 = 1
value = 0
movecamera = 0,0

[State 47003, VelAdd]
type = VelAdd
trigger1 = 1
y = 0.5

[State 47003, ChangeAnim2]
type = ChangeAnim2
trigger1 = Time = 0
value = 45000

[Statedef 47004]
type = A
movetype = H
physics = N
velset = 0,0

[State 47004, ChangeAnim2]
type = ChangeAnim2
trigger1 = Time = 0
value = 47004

[Statedef 47005]
type = A
movetype = H
physics = N
velset = 0,-40

[State 47005, ScreenBound]
type = ScreenBound
trigger1 = 1
value = 0
movecamera = 0,0

[State 47005, VelAdd]
type = VelAdd
trigger1 = 1
y = 0.35

[State 47005, ChangeAnim2]
type = ChangeAnim2
trigger1 = Time = 0
value = 45000

[State 47005, VelAdd]
type = VelAdd
trigger1 = Time > 1
y = 0.35

[State 47005, SelfState]
type = SelfState
trigger1 = (Vel Y > 0) && (Pos Y >= 0)
value = 5100

